package labirinto;

/**
 * L'intenzione era di consentire una sola istanza di Labiritnto perché esso
 * genera le stanze e il percorso verso l'obiettivo
 * 
 * @author koelio
 * 
 */
public class Labirinto {// facciamolo singleton

	private Stanza[][] lab = new Stanza[3][3];
	private String muro = "MURO";
	private String porta = "PORTA";
	private String baratro = "BARATRO";
	private String passaggio = "PASSAGGIO";

	public Labirinto() {
		generateLab();
	}

	public Stanza[][] generateLab() {

		// genera matrice 3x3
		lab = new Stanza[3][3];
		for (int i = 0; i < 3; i++) {
			for (int j = 0; j < 3; j++) {
				lab[i][j] = new Stanza();
			}
		}

		// definisco il percorso
		lab[0][0].creaMura(muro, muro, muro, muro);
		lab[1][0].creaMura(muro, porta, porta, passaggio);
		lab[1][0].getMura()[3].setTeleport(new int[]{2,2});// quando c'è un passaggio bisogna
											// impostare la stanza di
											// teletrasporto (in questo caso la (2,2)
		lab[2][0].creaMura(muro, muro, porta, porta);
		lab[0][1].creaMura(muro, porta, porta, muro);
		lab[1][1].creaMura(porta, muro, baratro, porta);
		lab[2][1].creaMura(porta, muro, porta, muro);
		lab[0][2].creaMura(porta, baratro, muro, muro);
		lab[1][2].creaMura(baratro, muro, muro, baratro);
		lab[2][2].creaMura(porta, muro, muro, passaggio);
		lab[2][2].getMura()[3].setTeleport(new int[]{1,0}); //teletrasporto di ritorno (0,0)
		lab[2][2].setVictory(true);

		return lab;
	}

}
